(function ($) {

    window.showWaiting = function () {
        $('.loading').removeClass('hide');
    };
    window.hideWaiting = function () {
        $('.loading').addClass('hide');
    };

    var restPath, windowId;

    TSM = {
        init: function (path, wid) {
            restPath = path;
            windowId = wid;
        },
        getRestPath: function (action) {
            path = restPath + '/' + action;
            if (path.indexOf("?") !== -1) {
                path += '&';
            } else {
                path += '?';
            }
            return  path + 'dswid=' + windowId;
        },
        showError: function (errorMessage) {
            $('#errorModal .errorName').text("");
            $('#errorModal .errorMessage').text(errorMessage);
            $('#errorModal').modal('show');
        }
    };

    $(document).ready(function () {
        // Starting keep alive
        if (window.name && window.name !== '') {
            setInterval(function () {
                $.get(TSM.getRestPath('keepalive'));
            }, 60000);
        }

        if (jsf) {
            jsf.ajax.addOnError(function (error) {
                $('#errorModal .errorName').text(error.errorName);
                $('#errorModal .errorMessage').text(error.errorMessage);
                if (error.errorName.indexOf('ViewExpiredException') !== -1) {
                    // If view has expired reload the page to display error message
                    location.reload();
                } else {
                    $('#errorModal').modal('show');
                }
            });

            // Setup loading animation
            jsf.ajax.addOnEvent(function (data) {
                if ($(data.source).is('input[type="text"]')) {
                    return; // special case
                }
                switch (data.status) {
                    case "begin":
                        showWaiting();
                        break;
                    case "complete":
                        hideWaiting();
                        break;
                }
            });
        }
    });

})(jQuery);
