/*
 * _____________________________________________________________________________
 * 
 * INAF - OATS National Institute for Astrophysics - Astronomical Observatory of
 * Trieste INAF - IA2 Italian Center for Astronomical Archives
 * _____________________________________________________________________________
 * 
 * Copyright (C) 2017 Istituto Nazionale di Astrofisica
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package it.inaf.ia2.tsm.webapp;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonObjectBuilder;

/**
 * REST Web Service
 *
 * @author Sonia Zorba {@literal <zorba at oats.inaf.it>}
 */
@Path("tap_schema")
@RequestScoped
public class TapSchemaLoaderResource {

    @Inject
    private SchemaSelectionBean schemaSelection;

    @GET
    @Path("status")
    public String getStatus() {
        JsonObjectBuilder job = Json.createObjectBuilder();
        job.add("loading", schemaSelection.isLoading());
        if (schemaSelection.getLoadingError() != null) {
            job.add("error", schemaSelection.getLoadingError());
        }
        return job.build().toString();
    }
}
