/*
 * _____________________________________________________________________________
 * 
 * INAF - OATS National Institute for Astrophysics - Astronomical Observatory of
 * Trieste INAF - IA2 Italian Center for Astronomical Archives
 * _____________________________________________________________________________
 * 
 * Copyright (C) 2017 Istituto Nazionale di Astrofisica
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package it.inaf.ia2.tsm.model;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

/**
 *
 * @author Sonia Zorba {@literal <zorba at oats.inaf.it>}
 */
public class Tasman {

    public static final String[] XML_MODEL_FILES;
    public static final boolean ALLOWS_FICTITIOUS_KEYS;

    static {
        try (InputStream in = Tasman.class.getClassLoader().getResourceAsStream("core.properties")) {
            Properties props = new Properties();
            props.load(in);
            String[] models = props.getProperty("models").split(",");
            XML_MODEL_FILES = new String[models.length];
            for (int i = 0; i < models.length; i++) {
                String suffix = models[i];
                XML_MODEL_FILES[i] = "tap_schema" + File.separator + "tap_schema-" + suffix + ".xml";
            }

            ALLOWS_FICTITIOUS_KEYS = Boolean.parseBoolean(props.getProperty("allow_fictitious_keys"));
        } catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}
