/*
 * _____________________________________________________________________________
 * 
 * INAF - OATS National Institute for Astrophysics - Astronomical Observatory of
 * Trieste INAF - IA2 Italian Center for Astronomical Archives
 * _____________________________________________________________________________
 * 
 * Copyright (C) 2017 Istituto Nazionale di Astrofisica
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package it.inaf.ia2.tsm.model;

import java.io.Serializable;

/**
 *
 * @author Sonia Zorba {@literal <zorba at oats.inaf.it>}
 */
public class PropertyModel implements Serializable {

    private static final long serialVersionUID = -3081516272534689428L;

    private String name;
    private String description;
    private Class type;
    private Integer size;
    private boolean updatable;
    private boolean nullable;
    private String loaderKey;
    private Object defaultValue;

    private PropertyModel() {
    }

    public PropertyModel(PropertyXMLModel propertyXMLModel) {
        try {
            name = propertyXMLModel.getName();
            description = propertyXMLModel.getDescription();
            type = Class.forName(propertyXMLModel.getType());
            size = propertyXMLModel.getSize();
            updatable = propertyXMLModel.isUpdatable();
            nullable = propertyXMLModel.isNullable();
            loaderKey = propertyXMLModel.getLoaderKey();
            if (propertyXMLModel.getDefaultValue() != null) {
                String strDefVal = propertyXMLModel.getDefaultValue();
                if (type == String.class) {
                    defaultValue = strDefVal;
                } else if (type == Integer.class) {
                    defaultValue = Integer.parseInt(strDefVal);
                } else if (type == Double.class) {
                    defaultValue = Double.parseDouble(strDefVal);
                } else if (type == Long.class) {
                    defaultValue = Long.parseLong(strDefVal);
                } else if (type == Float.class) {
                    defaultValue = Float.parseFloat(strDefVal);
                } else {
                    throw new UnsupportedOperationException("Default value for type " + type.getCanonicalName() + " not supported yet.");
                }
            }
        } catch (ClassNotFoundException e) {
            throw new ExceptionInInitializerError(
                    "Invalid property type for property " + propertyXMLModel.getName()
                    + ". ClassNotFoundException: " + propertyXMLModel.getType());
        }
    }

    public String getName() {
        return name;
    }

    public String getDescription() {
        return description;
    }

    public Class getType() {
        return type;
    }

    public Integer getSize() {
        return size;
    }

    public boolean isUpdatable() {
        return updatable;
    }

    public boolean isNullable() {
        return nullable;
    }

    public String getLoaderKey() {
        return loaderKey;
    }

    public Object getDefaultValue() {
        return defaultValue;
    }
}
