(function ($, TSM) {

    TSM.displayUpdateOperations = TSM.eventHandlerFactory(function (srcElement, jsupdate) {
        $('#updateOperationsModal').modal('show');
    });

    TSM.displayKeysModal = TSM.eventHandlerFactory(function (srcElement, jsupdate) {
        $('#keysModal').modal('show');
    });

    TSM.saveUCDCalled = TSM.eventHandlerFactory(function (srcElement, jsupdate) {
        if (jsupdate !== null) {
            $('#searchUCDModal').modal('hide');
        }
        // Hide loading
        $('.loading').addClass('hide');
    });

    TSM.textInputChanged = TSM.eventHandlerFactory(function (srcElement, jsupdate) {
        $(srcElement).toggleClass('changed', jsupdate === 'true');
    });

    TSM.stopPropagation = function (event) {
        event.stopPropagation();
        event.preventDefault();
        return false;
    };

    TSM.ucdTextKeyDown = function (event) {
        if (event.keyCode === 13) {
            $('#ucd_search_form\\:search_UCD_btn').click();
        }
    };

    TSM.openAddablesModal = function (event) {
        if (event.status === 'success') {
            $('#addablesModal').modal('show');
        }
    };

    TSM.entitiesAdded = function (event) {
        if (event.status === 'success') {
            $('#addablesModal').modal('hide');
        }
    };

    TSM.openSearchUCDModal = function (event) {
        if (event.status === 'success') {
            $('.loading').addClass('hide');
            $('#searchUCDModal').modal('show');
        }
    };

    TSM.closeSearchUCDModal = function (event) {
        if (event.status === 'success') {
            $('#searchUCDModal').modal('hide');
        }
    };

    TSM.notifyUpdate = function (event) {
        if (event.status === 'success' && $(event.responseXML).find('error').length === 0) {
            $('#updateSuccessModal').modal('show');
        }
    };

    TSM.updateFromModal = function () {
        $('#updateOperationsModal').modal('hide');
        $('#main\\:update-btn').click();
    };

})(jQuery, TSM);