/* 
 * _____________________________________________________________________________
 * 
 * INAF - OATS National Institute for Astrophysics - Astronomical Observatory of
 * Trieste INAF - IA2 Italian Center for Astronomical Archives
 * _____________________________________________________________________________
 * 
 * Copyright (C) 2016 Istituto Nazionale di Astrofisica
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package it.inaf.ia2.tsm.webapp.xmlconfig;

import it.inaf.ia2.tsm.datalayer.Credentials;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;

/**
 *
 * @author Sonia Zorba {@literal <zorba at oats.inaf.it>}
 */
public class SeparatedCredentials extends TapCredentials {

    private static final long serialVersionUID = 2108950341601128938L;

    private Credentials sourceCredentials;
    private Credentials tapSchemaCredentials;

    public SeparatedCredentials() {
        this.sourceCredentials = new Credentials();
        this.tapSchemaCredentials = new Credentials();
    }

    public SeparatedCredentials(Credentials sourceCredentials, Credentials tapSchemaCredentials) {
        this.sourceCredentials = sourceCredentials;
        this.tapSchemaCredentials = tapSchemaCredentials;
    }

    // Copy constructor
    public SeparatedCredentials(SeparatedCredentials separatedCredentials) {
        super(separatedCredentials);
        this.sourceCredentials = new Credentials(separatedCredentials.getSourceCredentials());
        this.tapSchemaCredentials = new Credentials(separatedCredentials.getTapSchemaCredentials());
    }

    @XmlElement(name = "source-credentials")
    public Credentials getSourceCredentials() {
        return sourceCredentials;
    }

    public void setSourceCredentials(Credentials sourceCredentials) {
        this.sourceCredentials = sourceCredentials;
    }

    @XmlElement(name = "tap-schema-credentials")
    public Credentials getTapSchemaCredentials() {
        return tapSchemaCredentials;
    }

    public void setTapSchemaCredentials(Credentials tapSchemaCredentials) {
        this.tapSchemaCredentials = tapSchemaCredentials;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + Objects.hashCode(this.sourceCredentials);
        hash = 53 * hash + Objects.hashCode(this.tapSchemaCredentials);
        hash = 53 * hash + Objects.hashCode(this.getTapSchemaName());
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final SeparatedCredentials other = (SeparatedCredentials) obj;

        if (!Objects.equals(this.sourceCredentials, other.getSourceCredentials())) {
            return false;
        }
        if (!Objects.equals(this.tapSchemaCredentials, other.getTapSchemaCredentials())) {
            return false;
        }
        return Objects.equals(this.getTapSchemaName(), other.getTapSchemaName());
    }
}
