package it.inaf.ia2.tap.tasman;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.StdErrLog;
import org.eclipse.jetty.webapp.WebAppContext;

/**
 *
 * @author Sonia Zorba {@literal <zorba at oats.inaf.it>}
 */
public class Main {

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) throws Exception {

        Properties props = new Properties();
        try (InputStream in = Main.class.getClassLoader().getResourceAsStream("app.properties")) {
            props.load(in);
        }

        // Printing the header
        try (BufferedReader br = new BufferedReader(new InputStreamReader(Main.class.getClassLoader().getResourceAsStream("header.txt")))) {
            for (String line; (line = br.readLine()) != null;) {
                System.out.println(line);
            }
        } catch (Exception e) {
        }

        int port = Integer.parseInt(props.getProperty("defaultPort").trim());
        String warFilePath = props.getProperty("warFilePath").trim();

        if (args.length == 1) {
            try {
                port = Integer.parseInt(args[0]);
            } catch (NumberFormatException e) {
                System.err.println("First argument must be a port number");
            }
        }

        final int serverPort = port;

        // Suppress log verbosity
        ((StdErrLog) Log.getRootLogger()).setLevel(StdErrLog.LEVEL_WARN);

        Server server = new Server(serverPort);

        WebAppContext webapp = new WebAppContext();
        webapp.setContextPath("/");
        File warFile = new File(warFilePath);
        webapp.setWar(warFile.getAbsolutePath());

        // https://bugs.eclipse.org/bugs/show_bug.cgi?id=477705
        // https://docs.jboss.org/weld/reference/latest/en-US/html/environments.html#_jetty
        webapp.prependServerClass("-org.eclipse.jetty.server.handler.ContextHandler");
        webapp.prependServerClass("-org.eclipse.jetty.servlet.FilterHolder");
        webapp.prependServerClass("-org.eclipse.jetty.servlet.ServletContextHandler");
        webapp.prependServerClass("-org.eclipse.jetty.servlet.ServletHolder");

        webapp.addEventListener(new ServletContextListener() {
            @Override
            public void contextInitialized(ServletContextEvent sce) {
                String message = "# TASMAN initialized. Visit http://localhost:" + serverPort + " #";
                printBorder(message);
                System.out.println(message);
                printBorder(message);
            }

            @Override
            public void contextDestroyed(ServletContextEvent sce) {
            }
        });

        server.setHandler(webapp);

        server.start();
        // The use of server.join() the will make the current thread join and
        // wait until the server is done executing.
        server.join();
    }

    private static void printBorder(String text) {
        for (int i = 0; i < text.length(); i++) {
            System.out.print("#");
        }
        System.out.println();
    }
}
