/*
 * _____________________________________________________________________________
 * 
 * INAF - OATS National Institute for Astrophysics - Astronomical Observatory of
 * Trieste INAF - IA2 Italian Center for Astronomical Archives
 * _____________________________________________________________________________
 * 
 * Copyright (C) 2017 Istituto Nazionale di Astrofisica
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package it.inaf.ia2.tsm.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;

/**
 * JAXB model containing information about a vendor-specific RDBMS datatype. The
 * name of the tag ("mysql" or "pgsql") identify the kind of database.
 *
 * @see TypesMapping
 * @author Sonia Zorba {@literal <zorba at oats.inaf.it>}
 */
public class DBTypeMapping {

    private boolean inverse;
    private final List<String> types;

    public DBTypeMapping() {
        types = new ArrayList<>();
    }

    /**
     * Tells if the {@link TypeMapping} having this element as a child must be
     * used to convert the vendor-specific datatype into a datatype used by
     * TASMAN.
     * <p>
     * This is necessary because there could be more ADQL types mapping to the
     * same database type (e.g. Postgres bytea datatype is used both for ADQL,
     * BLOB, BINARY and VARBINARY data types).
     */
    @XmlAttribute(name = "inverse")
    public boolean isInverse() {
        return inverse;
    }

    public void setInverse(boolean inverse) {
        this.inverse = inverse;
    }

    /**
     * Returns a list of datatype names that are considered synonymous by
     * TASMAN.
     */
    @XmlElements({
        @XmlElement(name = "type")
    })
    public List<String> getTypes() {
        return types;
    }
}
