/*
 * _____________________________________________________________________________
 * 
 * INAF - OATS National Institute for Astrophysics - Astronomical Observatory of
 * Trieste INAF - IA2 Italian Center for Astronomical Archives
 * _____________________________________________________________________________
 * 
 * Copyright (C) 2017 Istituto Nazionale di Astrofisica
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package it.inaf.ia2.tsm.datalayer;

/**
 * This enum is used to specify the syntax used by a TAP_SCHEMA for representing
 * the data types.
 * <p>
 * The {@code DataTypeMode} for a given TAP_SCHEMA is specified into the XML
 * configuration as an attribute of the schema element.
 *
 * @see it.inaf.ia2.tsm.model.SchemaModel
 * @author Sonia Zorba {@literal <zorba at oats.inaf.it>}
 */
public enum DataTypeMode {

    /**
     * For TAP 1.0: VARCHAR, SMALLINT, INTEGER, BIGINT, BLOB, ...
     */
    ADQL("ADQL"),
    /**
     * For TAP 1.1: char, short, int, long, unsignedByte, ...
     */
    VOTABLE("VOTable");

    private final String name;

    private DataTypeMode(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }
}
