/* 
 * _____________________________________________________________________________
 * 
 * INAF - OATS National Institute for Astrophysics - Astronomical Observatory of
 * Trieste INAF - IA2 Italian Center for Astronomical Archives
 * _____________________________________________________________________________
 * 
 * Copyright (C) 2016 Istituto Nazionale di Astrofisica
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package it.inaf.ia2.tsm.webapp;

import java.io.Serializable;

/**
 *
 * @author Sonia Zorba {@literal <zorba at oats.inaf.it>}
 */
public class UCDInfo implements Serializable {

    private static final long serialVersionUID = 585936072742567972L;

    private final String score;
    private final String flag;
    private final String word;
    private final String definition;
    private boolean selected;

    UCDInfo(String score, String flag, String word, String definition) {
        this.score = score;
        this.flag = flag;
        this.word = word;
        this.definition = definition;
    }

    public String getScore() {
        return score;
    }

    public String getFlag() {
        return flag;
    }

    public String getWord() {
        return word;
    }

    public String getDefinition() {
        return definition;
    }

    /**
     * Selection is used for UCD Rebuild functionality.
     */
    public boolean isSelected() {
        return selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public String getFlagExplanation() {
        switch (flag) {
            case "P":
                return "The code \"P\" means that the word can only be used as “primary” or first word";
            case "S":
                return "\"S\" stands for only secondary: the word cannot be used as the first word to describe a single quantity";
            case "Q":
                return "\"Q\" means that the word can be used indifferently as first or secondary word";
            case "E":
                return "\"E\" means a photometric quantity, and can be followed by a word describing a part of the electromagnetic spectrum";
            case "C":
                return "\"C\" is a colour index, and can be followed by two successive word describing a part of the electromagnetic spectrum";
            case "V":
                return "\"V\" stands for vector. Such a word can be followed by another describing the axis or reference frame in which the measurement is done";
            default:
                return null;
        }
    }
}
