/*
 * _____________________________________________________________________________
 * 
 * INAF - OATS National Institute for Astrophysics - Astronomical Observatory of
 * Trieste INAF - IA2 Italian Center for Astronomical Archives
 * _____________________________________________________________________________
 * 
 * Copyright (C) 2016 Istituto Nazionale di Astrofisica
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package it.inaf.ia2.tsm;

import java.io.Serializable;

/**
 *
 * @author Sonia Zorba {@literal <zorba at oats.inaf.it>}
 */
public class InconsistentColumnProperty implements Serializable {

    private static final long serialVersionUID = -5145865322582594970L;

    private ColumnHolder columnHolder;
    private String key;
    private Object currentValue;
    private Object correctValue;

    private InconsistentColumnProperty() {
    }

    public InconsistentColumnProperty(ColumnHolder columnHolder, String key, Object currentValue, Object correctValue) {
        this.columnHolder = columnHolder;
        this.key = key;
        this.currentValue = currentValue;
        this.correctValue = correctValue;
    }

    public ColumnHolder getColumnHolder() {
        return columnHolder;
    }

    public void setColumnHolder(ColumnHolder columnHolder) {
        this.columnHolder = columnHolder;
    }

    public String getTableCompleteName() {
        return String.format("%s.%s", columnHolder.getSchemaName(), columnHolder.getTableName());
    }

    public String getColumnName() {
        return columnHolder.getColumnName();
    }
    
    public String getKey() {
        return key;
    }

    public Object getCurrentValue() {
        return currentValue;
    }

    public Object getCorrectValue() {
        return correctValue;
    }
}
