/* 
 * _____________________________________________________________________________
 * 
 * INAF - OATS National Institute for Astrophysics - Astronomical Observatory of
 * Trieste INAF - IA2 Italian Center for Astronomical Archives
 * _____________________________________________________________________________
 * 
 * Copyright (C) 2016 Istituto Nazionale di Astrofisica
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package it.inaf.ia2.tsm;

import it.inaf.ia2.tsm.model.TableModel;
import java.util.Map;

/**
 * A {@link TapSchemaEntity} that can be a child of an
 * {@link EntitiesContainer}.
 *
 * @author Sonia Zorba {@literal <zorba at oats.inaf.it>}
 */
public abstract class ChildEntity<T extends EntitiesContainer> extends TapSchemaEntity {

    private static final long serialVersionUID = -8941059435527998685L;

    private Status status;

    /**
     * Only for serialization.
     */
    protected ChildEntity() {
    }

    /**
     * Default constructor.
     *
     * @see TapSchemaEntity
     */
    public ChildEntity(TapSchema tapSchema, TableModel tableModel, Map<String, Object> metadata) {
        super(tapSchema, tableModel, metadata);
    }

    /**
     * Returns the persistence status of this entity.
     */
    public Status getStatus() {
        return status;
    }

    /**
     * Updates the persistence status of this entity.
     */
    public void setStatus(Status status) {
        this.status = status;
    }

    /**
     * {@inheritDoc} The entity status becomes {@code Status.ADDED_PERSISTED}.
     */
    @Override
    public void save() {
        setStatus(Status.ADDED_PERSISTED);
        super.save();
    }

    /**
     * Returns the name of this entity. Each child has a name that is univocal
     * for a given parent, in this way the parent can search a child by name.
     */
    public abstract String getName();

    /**
     * Returns the {@link EntitiesContainer} that owns this object.
     */
    public abstract T getParent();
}
