/*
 * _____________________________________________________________________________
 * 
 * INAF - OATS National Institute for Astrophysics - Astronomical Observatory of
 * Trieste INAF - IA2 Italian Center for Astronomical Archives
 * _____________________________________________________________________________
 * 
 * Copyright (C) 2017 Istituto Nazionale di Astrofisica
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package it.inaf.ia2.tsm.datalayer;

/**
 * ADQL data type constants.
 *
 * @author Sonia Zorba {@literal <zorba at oats.inaf.it>}
 */
public enum ADQL {

    VARCHAR,
    CHAR,
    BOOLEAN,
    SMALLINT,
    INTEGER,
    BIGINT,
    REAL,
    DOUBLE,
    TIMESTAMP,
    CLOB,
    BLOB,
    BINARY,
    VARBINARY,
    REGION,
    POINT,
    CIRCLE,
    POLYGON;

    /**
     * Returns a string representing a datatype which can't be interpreted as an
     * ADQL datatype (that is in case of not standard data types). Removes
     * possible size appended at the end of datatype.
     */
    public static String getDataType(String dataType) {
        // removing size from datatype.
        return dataType.toUpperCase().replaceAll("\\(.+\\)", "");
    }

    /**
     * Tells if a datatype has a variable length.
     *
     * @param adql value of the datatype using ADQL syntax
     * @return true if the datatype has a variable length, false otherwise.
     */
    public static boolean isVariable(ADQL adql) {
        return adql.equals(VARCHAR) || adql.equals(VARBINARY) || adql.equals(CLOB) || adql.equals(BLOB);
    }

    public static ADQL parse(String adqlStr) {
        try {
            return ADQL.valueOf(adqlStr);
        } catch (IllegalArgumentException e) {
            return null;
        }
    }
}
