/* 
 * _____________________________________________________________________________
 * 
 * INAF - OATS National Institute for Astrophysics - Astronomical Observatory of
 * Trieste INAF - IA2 Italian Center for Astronomical Archives
 * _____________________________________________________________________________
 * 
 * Copyright (C) 2016 Istituto Nazionale di Astrofisica
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package it.inaf.ia2.tsm.webapp.xmlconfig;

import ari.ucidy.UCDSyntax;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;

/**
 * JAXB class for defining custom UCDs.
 *
 * @author Sonia Zorba {@literal <zorba at oats.inaf.it>}
 */
public class UCDConfiguration implements Serializable {

    private static final long serialVersionUID = 2741074893406134667L;

    private UCDSyntax syntax;
    private String word;
    private String description;
    private String creator;

    private UCDConfiguration() {
        syntax = UCDSyntax.BOTH;
    }

    public UCDConfiguration(String creator) {
        this();
        this.creator = creator;
    }

    @XmlElement(name = "code")
    public UCDSyntax getSyntax() {
        return syntax;
    }

    public void setSyntax(UCDSyntax syntax) {
        this.syntax = syntax;
    }

    /**
     * UCD word, including also custom namespace.
     */
    @XmlElement(name = "word")
    public String getWord() {
        return word;
    }

    public void setWord(String word) {
        this.word = word;
    }

    @XmlElement(name = "description")
    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * The user that created the UCD. This is used to assign delete privilege on
     * the UCD.
     */
    @XmlAttribute(name = "creator")
    public String getCreator() {
        return creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getCode() {
        switch (syntax) {
            case PRIMARY:
                return "P";
            case SECONDARY:
                return "S";
            case BOTH:
                return "Q";
            case PHOT_QUANTITY:
                return "E";
            case COLOUR:
                return "C";
            case VECTOR:
                return "V";
            default:
                throw new RuntimeException("No code defined for syntax " + syntax);
        }
    }
}
