/*
 * _____________________________________________________________________________
 * 
 * INAF - OATS National Institute for Astrophysics - Astronomical Observatory of
 * Trieste INAF - IA2 Italian Center for Astronomical Archives
 * _____________________________________________________________________________
 * 
 * Copyright (C) 2016 Istituto Nazionale di Astrofisica
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package it.inaf.ia2.tsm.webapp.env;

import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.FacesConverter;

/**
 * TAP_SCHEMA Manager inputText elements convert an empty input to null values.
 * This is specified in the web.xml using
 * javax.faces.INTERPRET_EMPTY_STRING_SUBMITTED_VALUES_AS_NULL and it's good to
 * avoid filling the database with empty values. However, there could be some
 * TAP_SCHEMA schemas edited with other tools that contains a lot of empty
 * strings instead null values. In that case on each click on the TAP_SCHEMA
 * editor that values will be updated to null marking the field as changed. This
 * could be confusing for the user, so this converter checks if the previous
 * value is an empty string and in that case bypass the conversion to null.
 *
 * @author Sonia Zorba {@literal <zorba at oats.inaf.it>}
 */
@FacesConverter("it.inaf.ia2.NullOrEmptyConverter")
public class NullOrEmptyConverter implements Converter {

    @Override
    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        String previousValue = (String) ((ValueHolder) component).getValue();
        if (value == null && previousValue != null && previousValue.isEmpty()) {
            return "";
        }
        return value;
    }

    @Override
    public String getAsString(FacesContext context, UIComponent component, Object value) {
        return (String) value;
    }
}
