
# TASMAN - [TA]P_[S]CHEMA [Man]ager

See also the [CHANGELOG](CHANGELOG.md).

## Build

### Build the API

    cd TASMAN-core
    mvn install

#### WARNING: test
Test suite for the TASMAN-core assumes some hardcoded values. If they
fail simply put an _@Ignore_ in front on the test class.

### Build the Web application

    cd TASMAN-webapp

Edit configuration properties file (`src/main/resources/webapp.properties`):

    ucd_service_url=<URL for the UCD REST web service>
    config_file_path=<location where the web app will store the generated XML configuration>

IA2 UCD service is at http://ia2-vo.oats.inaf.it:8080/ucd/

If the UCD web service is unreachable the web app will work anyway, but without the UCD search functionality.

Then build the web application:

* GlassFish war package (default):

        mvn install

* Tomcat war package:

        mvn -P Tomcat install

## Supported application servers

The web app was tested with:

* GlassFish 4.1
* Tomcat 8.0.33

The web app relies on specific JSF and EL versions, so it could not work in different application servers without a proper configuration.

#### WARNING: maven repo
Build requires _Ucidy_ and _Unity_ that are not available at central
maven repo. You should have them installed in a local maven repo.

To do this: download the jar files listed in the following
credits section and runn a couple of `mvn install:install-file`
commands based upond the dependencies description in the _TASMAN-webapp_
_pom.xml_ file.

## Credits

TAP_SCHEMA Manager web application uses the following VO libraries:

* Ucidy, by Grégory Mantelet (https://github.com/gmantele/ucidy)
* Unity, by Norman Gray (https://bitbucket.org/nxg/unity)
