#!/bin/bash

# Keep synchronized parent and children versions

if [ "$#" -ne 1 ]; then
  echo "Usage: $0 <version>"
  exit
fi

version=$1

cd TASMAN-bom
mvn -q versions:set -DnewVersion=$version
mvn -q clean install
cd ../TASMAN-core
mvn -q versions:update-parent -DparentVersion=$version
cd ../TASMAN-webapp
mvn -q versions:update-parent -DparentVersion=$version
cd ../TASMAN-embedded
mvn -q versions:update-parent -DparentVersion=$version

echo "Done"
