/*
 * _____________________________________________________________________________
 * 
 * INAF - OATS National Institute for Astrophysics - Astronomical Observatory of
 * Trieste INAF - IA2 Italian Center for Astronomical Archives
 * _____________________________________________________________________________
 * 
 * Copyright (C) 2017 Istituto Nazionale di Astrofisica
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package it.inaf.ia2.tsm.model;

import it.inaf.ia2.tsm.datalayer.DataTypeMode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

/**
 * JAXB model for defining a schema which is created and edited by TASMAN.
 *
 * @author Sonia Zorba {@literal <zorba at oats.inaf.it>}
 */
@XmlRootElement(name = "schema")
public class SchemaModel implements Serializable {

    private static final long serialVersionUID = 1087876778125446000L;

    private final List<TableModel> tables;

    private String name;
    private String version;
    private String extendsFrom;
    private String description;

    // Used only in TAP_SCHEMA
    private DataTypeMode dataTypeMode;

    public SchemaModel() {
        tables = new ArrayList<>();
    }

    @XmlAttribute(name = "name")
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlAttribute(name = "version")
    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    /**
     * The version from which this model inherits its structure.
     */
    @XmlAttribute(name = "extends")
    public String getExtendsFrom() {
        return extendsFrom;
    }

    public void setExtendsFrom(String extendsFrom) {
        this.extendsFrom = extendsFrom;
    }

    @XmlAttribute(name = "description")
    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @XmlElements({
        @XmlElement(name = "table")
    })
    public List<TableModel> getTables() {
        return tables;
    }

    public TableModel getTable(String tableName) {
        for (TableModel table : tables) {
            if (tableName.equals(table.getName())) {
                return table;
            }
        }
        return null;
    }

    /**
     * The format used for representing data types (used only for TAP_SCHEMA
     * models).
     */
    @XmlAttribute(name = "datatype")
    @XmlJavaTypeAdapter(DataTypeModeAdapter.class)
    public DataTypeMode getDataTypeMode() {
        return dataTypeMode;
    }

    public void setDataTypeMode(DataTypeMode dataTypeMode) {
        this.dataTypeMode = dataTypeMode;
    }
}
