(function ($, TSM) {

    var loading;

    function periodicCheck() {
        showWaiting();
        setTimeout(function () {
            $.get(TSM.getRestPath('tap_schema/status'), function (res) {
                var status = JSON.parse(res);
                if (status.loading) {
                    periodicCheck();
                } else {
                    if (status.error) {
                        hideWaiting();
                        TSM.showError(status.error);
                    } else {
                        // Perform redirect trick
                        $('#async-loader\\:open-loaded').click();
                    }
                }
            });
        }, 500);
    }

    TSM.asyncLoader = {

        init: function (l) {
            loading = l;
        },
        openTapSchemaClicked: function (event) {
            if (event.status === 'success' && $('.validation-message').length === 0) {
                var $tsExistenceEl = $(event.responseXML).find('jsupdate[src="tap_schema_existence"]');
                if ($tsExistenceEl.length === 1) {
                    if ($tsExistenceEl.text() === 'true') {
                        periodicCheck();
                    } else {
                        $('#modal-confirm-ts-creation').modal('show');
                    }
                }
            }
        },
        reloadClicked: function (event) {
            if (event.status === 'success') {
                periodicCheck();
            }
        },
        tapSchemaCreationConfirmed: function (event) {
            if (event.status === 'success') {
                periodicCheck();
            }
        }
    };

    $(document).ready(function () {
        if (loading) {
            periodicCheck();
        }
    });

})(jQuery, window.TSM);