package it.inaf.ia2.tsm.webapp;

import ari.ucidy.UCDParser;
import ari.ucidy.UCDWord;
import ari.ucidy.UCDWordList;
import it.inaf.ia2.tsm.webapp.xmlconfig.UCDConfiguration;
import java.io.IOException;
import java.util.List;

/**
 * This UCDParser load standard UCD values and add user-defined UCDs.
 *
 * @author Sonia Zorba {@literal <zorba at oats.inaf.it>}
 */
public class CustomizedUCDParser extends UCDParser {

    public CustomizedUCDParser(List<UCDConfiguration> customUCDs) {
        super();

        try {
            // Load standard UCD list
            knownWords.addAll(UCDWordList.class.getResourceAsStream("/ucd1p-words.txt"), true);
        } catch (NullPointerException | IOException e) {
            throw new ExceptionInInitializerError(e);
        }

        if (customUCDs != null) {
            // Add custom UCDs
            for (UCDConfiguration customUCD : customUCDs) {
                knownWords.add(new UCDWord(customUCD.getSyntax(), customUCD.getWord(), customUCD.getDescription(), false));
            }
        }
    }
}
