package it.inaf.ia2.tap.tasman;

import java.io.File;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.StdErrLog;
import org.eclipse.jetty.webapp.WebAppContext;

/**
 *
 * @author Sonia Zorba {@literal <zorba at oats.inaf.it>}
 */
public class Main {

    private static final int DEFAULT_PORT = 8080;

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) throws Exception {

        int port = DEFAULT_PORT;

        if (args.length == 1) {
            try {
                port = Integer.parseInt(args[0]);
            } catch (NumberFormatException e) {
                System.err.println("First argument must be a port number");
            }
        }

        final int serverPort = port;

        // Suppress log verbosity
        ((StdErrLog) Log.getRootLogger()).setLevel(StdErrLog.LEVEL_WARN);

        Server server = new Server(serverPort);

        WebAppContext webapp = new WebAppContext();
        webapp.setContextPath("/");
        File warFile = new File("/home/sonia/git/TASMAN/TASMAN-webapp/target/tasman-webapp-1.2.0.war");
        webapp.setWar(warFile.getAbsolutePath());

        // https://bugs.eclipse.org/bugs/show_bug.cgi?id=477705
        // https://docs.jboss.org/weld/reference/latest/en-US/html/environments.html#_jetty
        webapp.prependServerClass("-org.eclipse.jetty.server.handler.ContextHandler");
        webapp.prependServerClass("-org.eclipse.jetty.servlet.FilterHolder");
        webapp.prependServerClass("-org.eclipse.jetty.servlet.ServletContextHandler");
        webapp.prependServerClass("-org.eclipse.jetty.servlet.ServletHolder");

        webapp.addEventListener(new ServletContextListener() {
            @Override
            public void contextInitialized(ServletContextEvent sce) {
                System.out.println("TASMAN initialized. Visit http://localhost:" + serverPort);
            }

            @Override
            public void contextDestroyed(ServletContextEvent sce) {
            }
        });

        server.setHandler(webapp);

        server.start();
        // The use of server.join() the will make the current thread join and
        // wait until the server is done executing.
        server.join();
    }
}
