/*
 * _____________________________________________________________________________
 * 
 * INAF - OATS National Institute for Astrophysics - Astronomical Observatory of
 * Trieste INAF - IA2 Italian Center for Astronomical Archives
 * _____________________________________________________________________________
 * 
 * Copyright (C) 2017 Istituto Nazionale di Astrofisica
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package it.inaf.ia2.tsm.model;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;

/**
 *
 * @author Sonia Zorba {@literal <zorba at oats.inaf.it>}
 */
public class TypeMapping {

    private String adqlType;
    private String mysqlType;
    private String pgsqlType;
    private String javaTypeString;

    @XmlElement(name = "adql")
    public String getAdqlType() {
        return adqlType;
    }

    public void setAdqlType(String adqlType) {
        this.adqlType = adqlType;
    }

    @XmlElement(name = "mysql")
    public String getMySQLType() {
        return mysqlType;
    }

    public void setMySQLType(String mysqlType) {
        this.mysqlType = mysqlType;
    }

    @XmlElement(name = "pgsql")
    public String getPgsqlType() {
        return pgsqlType;
    }

    public void setPgsqlType(String pgsqlType) {
        this.pgsqlType = pgsqlType;
    }

    @XmlElement(name = "java")
    public String getJavaTypeString() {
        return javaTypeString;
    }

    public void setJavaTypeString(String javaTypeString) {
        this.javaTypeString = javaTypeString;
    }

    @XmlTransient
    public Class getJavaType() {
        try {
            return Class.forName(javaTypeString);
        } catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }
}
