/*
 * _____________________________________________________________________________
 * 
 * INAF - OATS National Institute for Astrophysics - Astronomical Observatory of
 * Trieste INAF - IA2 Italian Center for Astronomical Archives
 * _____________________________________________________________________________
 * 
 * Copyright (C) 2017 Istituto Nazionale di Astrofisica
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package it.inaf.ia2.tsm.model;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;

/**
 *
 * @author Sonia Zorba {@literal <zorba at oats.inaf.it>}
 */
public class PropertyModel implements Serializable {

    private static final long serialVersionUID = -982004697900839996L;

    private String name;
    private String type;
    private Integer size;
    private boolean updatable;
    private boolean nullable;
    private boolean standard;
    private boolean mandatory;
    private String defaultValueString;
    private String loaderKey;
    private String description;
    private String ucd;
    private String utype;
    private String unit;
    private boolean principal;

    public PropertyModel() {
        // default values
        updatable = true;
        nullable = true;
        // Currently this is used only for ObsCore
        mandatory = true;
    }

    @XmlElement(name = "name")
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlElement(name = "type")
    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @XmlElement(name = "size")
    public Integer getSize() {
        return size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    @XmlElement(name = "updatable", defaultValue = "true")
    public boolean isUpdatable() {
        return updatable;
    }

    public void setUpdatable(boolean updatable) {
        this.updatable = updatable;
    }

    @XmlElement(name = "nullable", defaultValue = "true")
    public boolean isNullable() {
        return nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    @XmlElement(name = "standard", defaultValue = "false")
    public boolean isStandard() {
        return standard;
    }

    public void setStandard(boolean standard) {
        this.standard = standard;
    }

    @XmlElement(name = "mandatory", defaultValue = "true")
    public boolean isMandatory() {
        return mandatory;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    @XmlElement(name = "default-value")
    public String getDefaultValueString() {
        return defaultValueString;
    }

    public void setDefaultValueString(String defaultValue) {
        this.defaultValueString = defaultValue;
    }

    @XmlElement(name = "key")
    public String getLoaderKey() {
        return loaderKey;
    }

    public void setLoaderKey(String loaderMethod) {
        this.loaderKey = loaderMethod;
    }

    @XmlElement(name = "description")
    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @XmlElement(name = "ucd")
    public String getUcd() {
        return ucd;
    }

    public void setUcd(String ucd) {
        this.ucd = ucd;
    }

    @XmlElement(name = "utype")
    public String getUtype() {
        return utype;
    }

    public void setUtype(String utype) {
        this.utype = utype;
    }

    @XmlElement(name = "unit")
    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    @XmlElement(name = "principal", defaultValue = "false")
    public boolean isPrincipal() {
        return principal;
    }

    public void setPrincipal(boolean principal) {
        this.principal = principal;
    }

    @XmlTransient
    public Object getDefaultValue() {
        if (defaultValueString == null) {
            return null;
        }
        return TypesMapping.parseDefaultValue(defaultValueString, getType());
    }

    @XmlTransient
    public Class getJavaType() {
        return TypesMapping.getClassFromAdqlType(getType());
    }
}
