package it.inaf.ia2.tap.tasman;

import java.io.File;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.webapp.WebAppContext;

/**
 *
 * @author Sonia Zorba {@literal <zorba at oats.inaf.it>}
 */
public class Main {

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) throws Exception {
        Server server = new Server(2500);

        WebAppContext webapp = new WebAppContext();
        webapp.setContextPath("/");
        File warFile = new File("/home/sonia/git/TASMAN/TASMAN-webapp/target/tasman-webapp-1.2.0.war");
        webapp.setWar(warFile.getAbsolutePath());

        // https://bugs.eclipse.org/bugs/show_bug.cgi?id=477705
        //https://docs.jboss.org/weld/reference/latest/en-US/html/environments.html#_jetty
        webapp.prependServerClass("-org.eclipse.jetty.server.handler.ContextHandler");
        webapp.prependServerClass("-org.eclipse.jetty.servlet.FilterHolder");
        webapp.prependServerClass("-org.eclipse.jetty.servlet.ServletContextHandler");
        webapp.prependServerClass("-org.eclipse.jetty.servlet.ServletHolder");

        server.setHandler(webapp);

        server.start();
        server.dumpStdErr();

        // The use of server.join() the will make the current thread join and
        // wait until the server is done executing.
        server.join();
    }
}
