/*
 * _____________________________________________________________________________
 * 
 * INAF - OATS National Institute for Astrophysics - Astronomical Observatory of
 * Trieste INAF - IA2 Italian Center for Astronomical Archives
 * _____________________________________________________________________________
 * 
 * Copyright (C) 2017 Istituto Nazionale di Astrofisica
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package it.inaf.ia2.tsm.datalayer;

import com.mysql.jdbc.jdbc2.optional.MysqlDataSource;
import java.io.Serializable;
import javax.sql.DataSource;
import org.postgresql.ds.PGPoolingDataSource;

/**
 * Serializable wrapper for a DataSource.
 *
 * @author Sonia Zorba {@literal <zorba at oats.inaf.it>}
 */
public class DataSourceWrapper implements Serializable {

    private static final long serialVersionUID = -7658342136473761826L;

    private Credentials credentials;
    private transient DataSource dataSource;

    private DataSourceWrapper() {
    }

    public DataSourceWrapper(Credentials credentials) {
        this.credentials = credentials;
    }

    public DataSource getDataSource() {
        if (dataSource == null) {
            switch (credentials.getDatabaseType()) {

                case MYSQL:
                    MysqlDataSource myds = new MysqlDataSource();

                    myds.setServerName(credentials.getHostname());
                    myds.setPortNumber(credentials.getPort());
                    myds.setUser(credentials.getUsername());
                    myds.setPassword(credentials.getPassword());

                    return myds;

                case POSTGRES:
                    PGPoolingDataSource pgds = new PGPoolingDataSource();

                    pgds.setServerName(credentials.getHostname());
                    pgds.setPortNumber(credentials.getPort());
                    pgds.setUser(credentials.getUsername());
                    pgds.setPassword(credentials.getPassword());
                    pgds.setDatabaseName(credentials.getDatabase());

                    return pgds;

                default:
                    throw new UnsupportedOperationException(credentials.getDatabaseType() + " not supported yet.");
            }
        }
        return dataSource;
    }

    public DatabaseType getDatabaseType() {
        return credentials.getDatabaseType();
    }

    public Credentials getCredentials() {
        return credentials;
    }
}
