
# TASMAN - [TA]P_[S]CHEMA [Man]ager

See also the [CHANGELOG](CHANGELOG.md).

## Build

1. Create a `config.properties` file (copy it from `config.properties.example`). In this file it is specified:
    * **ucd_service_url**: the URL for the UCD REST web service.
        * IA2 UCD service is at http://ia2-vo.oats.inaf.it/ucd/
        * if the UCD web service is unreachable the web app will work anyway, but without the UCD search functionality.
    * **config_file_path**: the location where the web app will store the generated XML configuration (the location needs to be writable by the application server in which TASMAN will run).

2. `chmod +x build.sh`
3. `./build.sh <command>`, commands are:
    * **core** build only TASMAN core
    * **test**: run tests; you need to create a `test.properties` file containing a configuration for connecting to a MySQL and a Postgres test database
        * MySQL testing database needs to have `default-storage-engine = innodb` configured into `/etc/my.cnf`
        * Postgres 9.3+ is required
    * **glassfish**: build GlassFish war package
    * **tomcat**: build Tomcat war package (using config.properties file)
    * **embedded**: build embedded package (to be run _locally!_)
    * **installer**: build install script (produce self-extracting install.sh script)

## Supported application servers

The web app has been tested with:

* GlassFish 4.1
* Tomcat 8.0.33

The web app relies on specific JSF and EL versions, so it could not work in different application servers without a proper configuration.

#### WARNING: maven repo
Build requires _Ucidy_ and _Unity_ that are not available at central
maven repo. You should have them installed in a local maven repo.

To do this: download the jar files listed in the following
credits section and run a couple of `mvn install:install-file`
commands based upond the dependencies description in the _TASMAN-webapp_ _pom.xml_ file.

    mvn install:install-file -Dfile=ucidy-1.1.jar -DgroupId=ari.ucidy -DartifactId=ucidy -Dversion=1.1 -Dpackaging=jar
    mvn install:install-file -Dfile=unity-1.0.jar -DgroupId=uk.me.nxg -DartifactId=unity -Dversion=1.0 -Dpackaging=jar

## Developers info

For debugging TASMAN-embedded:

    java -jar -Xdebug -agentlib:jdwp=transport=dt_socket,address=9999,server=y,suspend=n /opt/tasman/tasman-embedded.jar 2000

## Credits

TAP_SCHEMA Manager web application uses the following VO libraries:

* Ucidy, by Grégory Mantelet (https://github.com/gmantele/ucidy)
* Unity, by Norman Gray (https://bitbucket.org/nxg/unity)
