(function () {

    var restPath, windowId;

    window.credentials = {
        init: function (path, wid) {
            restPath = path;
            windowId = wid;
        },
        editClicked: function (event) {
            if (event.status === 'success') {
                $('#credentials-modal').modal('show');
            }
        },
        credentialsSaved: function (event) {
            if (event.status === 'success') {
                if ($('#credentials-modal .text-danger').length === 0) {
                    $('#credentials-modal').modal('hide');
                }
            }
        }
    };

    $(document).ready(function () {
        $('body').on('shown.bs.modal', '#credentials-modal', function ( ) {
            $.post(restPath + "/credentialsDialog?opened=true&dswid=" + windowId);
        });
        $('body').on('hidden.bs.modal', '#credentials-modal', function ( ) {
            $.post(restPath + "/credentialsDialog?opened=false&dswid=" + windowId);
        });

        $('body').on('keyup', '#credentials-modal input', function (event) {
            if (event.keyCode === 13) {
                $('#main\\:save-credentials').click();
                event.preventDefault();
            }
        })
    });
})();
