/* 
 * _____________________________________________________________________________
 * 
 * INAF - OATS National Institute for Astrophysics - Astronomical Observatory of
 * Trieste INAF - IA2 Italian Center for Astronomical Archives
 * _____________________________________________________________________________
 * 
 * Copyright (C) 2016 Istituto Nazionale di Astrofisica
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package it.inaf.ia2.tsm.webapp;

import it.inaf.ia2.tsm.webapp.xmlconfig.UserConfiguration;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.deltaspike.core.api.scope.WindowScoped;

/**
 *
 * @author Sonia Zorba {@literal <zorba at oats.inaf.it>}
 */
@Named
@WindowScoped
public class UsersEditing implements Serializable {

    private static final long serialVersionUID = -8758568990541836689L;

    @Inject
    private ConfigurationData config;

    private List<UserConfiguration> users;

    @PostConstruct
    public void init() {
        users = new ArrayList<>();
    }

    public String open() {
        // Copying users list (to avoid issues caused by simultaneously changes)
        users = config.cloneUsersConfiguration();
        return "usersEditing.xhtml?faces-redirect=true";
    }

    public List<UserConfiguration> getUsers() {
        return users;
    }

    public void save() throws IOException {
        config.updateUsersList(users);
    }

    public void addUser() {
        users.add(new UserConfiguration());
    }

    public void removeUser(int index) {
        users.remove(index);
    }
}
