/* 
 * _____________________________________________________________________________
 * 
 * INAF - OATS National Institute for Astrophysics - Astronomical Observatory of
 * Trieste INAF - IA2 Italian Center for Astronomical Archives
 * _____________________________________________________________________________
 * 
 * Copyright (C) 2016 Istituto Nazionale di Astrofisica
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package it.inaf.ia2.tsm.api.contract;

import java.util.List;

/**
 * {@link TapSchemaEntity} that represents the table {@code TAP_SCHEMA.tables}.
 *
 * @author Sonia Zorba {@literal <zorba at oats.inaf.it>}
 */
public interface Table extends EntitiesContainer<Column>, ChildEntity<Schema> {

    final static String SCHEMA_NAME_KEY = "schema_name";
    final static String TABLE_NAME_KEY = "table_name";
    final static String TABLE_TYPE_KEY = "table_type";
    final static String UTYPE_KEY = "utype";
    final static String DESCRIPTION_KEY = "description";
    final static String TABLE_INDEX = "table_index";
    final static String TABLE_ID = "tableID";

    /**
     * The value in the {@code schema_name} column.
     */
    String getSchemaName();

    /**
     * The value in the {@code table_name} column: it represents the complete
     * table name: {@code schema_name.table_name}.
     */
    String getCompleteName();

    /**
     * The value in the {@code table_type} column: it could be {@code table} or
     * {@code view}.
     */
    String getTableType();

    Integer getTableIndex();

    void setTableIndex(Integer tableIndex);

    /**
     * The value in the {@code tableID} column: it represents [TODO]...
     */
    Long getTableID();

    void setTableID(Long tableID);

    /**
     * Retrieve the list of all the visible keys whose
     * {@link Key#getFromTableCompleteName()} method returns the complete name
     * of this table.
     */
    List<Key> getVisibleFromKeys();

    /**
     * Retrieve the list of all the keys (both visible and not visible) whose
     * {@link Key#getFromTableCompleteName()} method returns the complete name
     * of this table.
     */
    List<Key> getAllFromKeys();

    /**
     * Retrieve the list of all the visible keys whose
     * {@link Key#getTargetTableCompleteName()} method returns the complete name
     * of this table.
     */
    List<Key> getVisibleTargetKeys();

    /**
     * Retrieve the list of all the keys (both visible and not visible) whose
     * {@link Key#getTargetTableCompleteName()} method returns the complete name
     * of this table.
     */
    List<Key> getAllTargetKeys();

    void addFromKey(Key key);

    void addTargetKey(Key key);

    /**
     * The value in the {@code utype} column.
     */
    String getUtype();

    void setUtype(String utype);

    /**
     * The value in the {@code description} column.
     */
    String getDescription();

    void setDescription(String description);
}
