(function ($) {

    window.showWaiting = function () {
        $('.loading').removeClass('hide');
    };
    window.hideWaiting = function () {
        $('.loading').addClass('hide');
    };

    var restPath, windowId;

    TSM = {
        init: function (path, wid) {
            restPath = path;
            windowId = wid;
        },
        getRestPath: function (action) {
            path = restPath + '/' + action;
            if (path.indexOf("?") !== -1) {
                path += '&';
            } else {
                path += '?';
            }
            return  path + 'dswid=' + windowId;
        },
        showError: function (errorMessage) {
            $('#errorModal .errorName').text("");
            $('#errorModal .errorMessage').text(errorMessage);
            $('#errorModal').modal('show');
        },
        doOnSuccess: function (callback) {
            return function (event) {
                if (event.status === 'success'
                        && $(event.responseXML).find('error').length === 0) {
                    callback();
                }
            };
        },
        // Function factory to handle custom communications between the backing bean and JavaScript functions
        eventHandlerFactory: function (handler, componentId) {
            return function (event) {

                if (event.status === 'success'
                        && $(event.responseXML).find('error').length === 0) {

                    var srcId = componentId ? componentId : event.source.getAttribute('id');
                    var jsUpdate = null;

                    var jsupdates = event.responseXML.getElementById('jsupdates');
                    if (jsupdates) {
                        jsupdates = jsupdates.childNodes;
                        for (var i = 0; i < jsupdates.length; i++) {
                            var jsu = jsupdates[i];
                            if (jsu.getAttribute('src') === srcId) {
                                jsUpdate = jsu.innerText || jsu.textContent;
                                break;
                            }
                        }
                    }

                    handler(event.source, jsUpdate);
                }
            };
        }
    };

    $(document).ready(function () {
        // Starting keep alive
        if (window.name && window.name !== '') {
            setInterval(function () {
                $.get(TSM.getRestPath('keepalive'));
            }, 60000);
        }

        if (jsf) {
            jsf.ajax.addOnError(function (error) {
                // Close all previously opened modals.
                $('.modal').modal('hide');

                $('#errorModal .errorName').text(error.errorName);
                $('#errorModal .errorMessage').text(error.errorMessage);
                if (error.errorName.indexOf('ViewExpiredException') !== -1) {
                    // If view has expired reload the page to display error message
                    location.reload();
                } else {
                    $('#errorModal').modal('show');
                }
            });

            // Setup loading animation
            // Restore scroll position after JSF AJAX update
            var windowScroll, columnsScroll;
            jsf.ajax.addOnEvent(function (data) {
                if ($(data.source).is('input[type="text"]') ||
                        $(data.source).is('[data-jsf-modal]')) {
                    return; // special case
                }
                switch (data.status) {
                    case "begin":
                        showWaiting();
                        break;
                    case "complete":
                        hideWaiting();
                        windowScroll = window.scrollY;
                        columnsScroll = $('.columns-selector').scrollTop();
                        break;
                    case "success":
                        window.scrollY = windowScroll;
                        $('.columns-selector').scrollTop(columnsScroll);
                        break;
                }
            });
        }
    });

})(jQuery);
