package it.inaf.ia2.tsm.webapp;

import java.io.IOException;
import java.io.InputStream;
import java.util.Scanner;

/**
 * Static class for sharing version number inside the application.
 * 
 * @author Sonia Zorba {@literal <zorba at oats.inaf.it>}
 */
public class Version {

    public final static String NUMBER;

    static {
        try (InputStream is = Version.class.getClassLoader().getResourceAsStream("version.txt")) {
            Scanner s = new Scanner(is).useDelimiter("\\A");
            NUMBER = s.next().trim();
        } catch (IOException e) {
            throw new ExceptionInInitializerError("File version.txt not found in the war package!");
        }
    }
}
