/*
 * _____________________________________________________________________________
 * 
 * INAF - OATS National Institute for Astrophysics - Astronomical Observatory of
 * Trieste INAF - IA2 Italian Center for Astronomical Archives
 * _____________________________________________________________________________
 * 
 * Copyright (C) 2016 Istituto Nazionale di Astrofisica
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package it.inaf.ia2.tsm.webapp;

import it.inaf.ia2.tsm.TapSchema;
import it.inaf.ia2.tsm.TapSchemaMender;
import java.io.Serializable;
import java.sql.SQLException;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.deltaspike.core.api.scope.WindowScoped;

/**
 *
 * @author Sonia Zorba {@literal <zorba at oats.inaf.it>}
 */
@WindowScoped
@Named("consistency")
public class ConsistencyChecksBean implements Serializable {

    private static final long serialVersionUID = 2883609252747956266L;

    @Inject
    TapSchemaEditingBean tapSchemaEditingBean;

    private TapSchema tapSchema;

    public TapSchema getTapSchema() {
        return tapSchema;
    }

    public void setTapSchema(TapSchema tapSchema) {
        this.tapSchema = tapSchema;
    }

    public boolean isTapSchemaContainsOnlyTapSchema() {
        return tapSchema.getChildren().size() == 1
                && tapSchema.getChildren().get(0).getName().equals(tapSchema.getName());
    }

    public String proceed() throws SQLException {
        TapSchemaMender.amendTapSchema(tapSchema);
        tapSchema.save();
        tapSchemaEditingBean.setTapSchema(tapSchema);
        return "tapSchemaEditing.xhtml?faces-redirect=true";
    }

    public String back() {
        return "credentialsEditing.xhtml?faces-redirect=true";
    }
}
