/*
 * _____________________________________________________________________________
 * 
 * INAF - OATS National Institute for Astrophysics - Astronomical Observatory of
 * Trieste INAF - IA2 Italian Center for Astronomical Archives
 * _____________________________________________________________________________
 * 
 * Copyright (C) 2017 Istituto Nazionale di Astrofisica
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package it.inaf.ia2.tsm.model;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;

/**
 *
 * @author Sonia Zorba {@literal <zorba at oats.inaf.it>}
 */
public class TypeMapping {

    private String adqlType;
    private String voTableType;
    private DBTypeMapping mysqlMapping;
    private DBTypeMapping pgsqlMapping;
    private String javaTypeString;

    @XmlElement(name = "adql")
    public String getAdqlType() {
        return adqlType;
    }

    public void setAdqlType(String adqlType) {
        this.adqlType = adqlType;
    }

    @XmlElement(name = "votable")
    public String getVoTableType() {
        return voTableType;
    }

    public void setVoTableType(String voTableType) {
        this.voTableType = voTableType;
    }

    @XmlElement(name = "mysql")
    public DBTypeMapping getMySQLMapping() {
        return mysqlMapping;
    }

    public void setMySQLMapping(DBTypeMapping mysqlMapping) {
        this.mysqlMapping = mysqlMapping;
    }

    @XmlElement(name = "pgsql")
    public DBTypeMapping getPgsqlMapping() {
        return pgsqlMapping;
    }

    public void setPgsqlMapping(DBTypeMapping pgsqlMapping) {
        this.pgsqlMapping = pgsqlMapping;
    }

    @XmlElement(name = "java")
    public String getJavaTypeString() {
        return javaTypeString;
    }

    public void setJavaTypeString(String javaTypeString) {
        this.javaTypeString = javaTypeString;
    }

    @XmlTransient
    public Class getJavaType() {
        try {
            return Class.forName(javaTypeString);
        } catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }
}
