/*
 * _____________________________________________________________________________
 * 
 * INAF - OATS National Institute for Astrophysics - Astronomical Observatory of
 * Trieste INAF - IA2 Italian Center for Astronomical Archives
 * _____________________________________________________________________________
 * 
 * Copyright (C) 2017 Istituto Nazionale di Astrofisica
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package it.inaf.ia2.tsm.datalayer;

import it.inaf.ia2.tsm.ColumnHolder;
import it.inaf.ia2.tsm.ConsistencyChecks;
import it.inaf.ia2.tsm.Key;
import it.inaf.ia2.tsm.TapSchema;
import it.inaf.ia2.tsm.TapSchemaEntity;
import it.inaf.ia2.tsm.model.ColumnModel;
import it.inaf.ia2.tsm.model.TableModel;
import it.inaf.ia2.tsm.model.SchemaModel;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 *
 * @author Sonia Zorba {@literal <zorba at oats.inaf.it>}
 */
public interface DBBroker {

    List<String> getAllSchemaNames() throws SQLException;

    List<String> getAllTAPSchemaNames(List<String> allSchemas) throws SQLException;

    String detectVersion(String tapSchemaName) throws SQLException;

    List<String> getExposedSchemas(String tapSchemaName) throws SQLException;

    List<String> getAllTablesNames(String schemaName) throws SQLException;

    Map<String, String> getAllTableTypes(String schemaName) throws SQLException;

    List<String> getAllColumnsNames(String schemaName, String tableName) throws SQLException;

    Map<String, Map<String, Object>> getAllColumnsMetadata(String schemaName, String tableSimpleName, TableModel tableModel, String tapSchemaVersion) throws SQLException;

    List<Key> getKeys(TapSchema tapSchema, String schemaName) throws SQLException;

    List<Map<String, Object>> getSavedItems(String tapSchemaName, TableModel tableModel, String whereCondition, Object[] whereParams) throws SQLException;

    List<Map<String, Object>> getSavedItems(String tapSchemaName, TableModel tableModel) throws SQLException;

    void insertItem(String tapSchemaName, TapSchemaEntity entity, Connection conn) throws SQLException;

    void updateItem(String tapSchemaName, TapSchemaEntity entity, Connection conn, String whereCondition, Object... whereParams) throws SQLException;

    void createTapSchemaStructure(String tapSchemaName, SchemaModel tapSchemaModel) throws SQLException;

    void createIvoaSchemaStructure(SchemaModel ivoaSchemaModel) throws SQLException;

    void save(TapSchema tapSchema) throws SQLException;

    void createTable(String schemaName, TableModel tableModel) throws SQLException;

    void addColumn(ColumnHolder columnHolder, ColumnModel columnModel) throws SQLException;

    /**
     * @param like is for using both the schema name and the complete table name
     * in the query
     */
    Set<String> getKeysToRemove(String tapSchemaName, String like) throws SQLException;

    void deleteUnexistingEntities(String tapSchemaName, ConsistencyChecks consistencyChecks, Set<String> keysToRemoveIds) throws SQLException;

    Set<String> getKeysToRemoveFromUnexistingColumn(String tapSchemaName, ColumnHolder unexistingColumn) throws SQLException;

    void updateTapSchemaColumnValue(String tapSchemaName, String completeTableName, String columnName, String key, Object value) throws SQLException;
}
