/*
 * _____________________________________________________________________________
 * 
 * INAF - OATS National Institute for Astrophysics - Astronomical Observatory of
 * Trieste INAF - IA2 Italian Center for Astronomical Archives
 * _____________________________________________________________________________
 * 
 * Copyright (C) 2016 Istituto Nazionale di Astrofisica
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package it.inaf.ia2.tsm;

import java.io.Serializable;

/**
 *
 * @author Sonia Zorba {@literal <zorba at oats.inaf.it>}
 */
public class InconsistentColumnProperty implements Serializable {

    private static final long serialVersionUID = -5145865322582594970L;

    private String tableCompleteName;
    private String columnName;
    private String key;
    private Object currentValue;
    private Object correctValue;

    private InconsistentColumnProperty() {
    }

    public InconsistentColumnProperty(String tableCompleteName, String columnName, String key, Object currentValue, Object correctValue) {
        this.tableCompleteName = tableCompleteName;
        this.columnName = columnName;
        this.key = key;
        this.currentValue = currentValue;
        this.correctValue = correctValue;
    }

    public String getTableCompleteName() {
        return tableCompleteName;
    }

    public String getColumnName() {
        return columnName;
    }

    public String getKey() {
        return key;
    }

    public Object getCurrentValue() {
        return currentValue;
    }

    public Object getCorrectValue() {
        return correctValue;
    }
}
