/*
 * _____________________________________________________________________________
 * 
 * INAF - OATS National Institute for Astrophysics - Astronomical Observatory of
 * Trieste INAF - IA2 Italian Center for Astronomical Archives
 * _____________________________________________________________________________
 * 
 * Copyright (C) 2017 Istituto Nazionale di Astrofisica
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package it.inaf.ia2.tsm.webapp.xmlconfig;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlElement;

/**
 *
 * @author Sonia Zorba {@literal <zorba at oats.inaf.it>}
 */
public abstract class TapCredentials implements Serializable {

    private static final long serialVersionUID = -3736612935129057338L;

    private String tapSchemaName;
    private String tapSchemaVersion;
    private boolean hasObscore;
    private String obscoreVersion;

    public TapCredentials() {
    }

    // Copy constructor
    public TapCredentials(TapCredentials tapCredentials) {
        this.tapSchemaName = tapCredentials.getTapSchemaName();
        this.tapSchemaVersion = tapCredentials.getTapSchemaVersion();
        this.hasObscore = tapCredentials.isHasObscore();
    }

    @XmlElement(name = "tap_schema_name")
    public String getTapSchemaName() {
        return tapSchemaName;
    }

    public void setTapSchemaName(String tapSchemaName) {
        this.tapSchemaName = tapSchemaName;
    }

    @XmlElement(name = "tap_schema_version")
    public String getTapSchemaVersion() {
        return tapSchemaVersion;
    }

    public void setTapSchemaVersion(String tapSchemaVersion) {
        this.tapSchemaVersion = tapSchemaVersion;
    }

    @XmlElement(name = "obscore")
    public boolean isHasObscore() {
        return hasObscore;
    }

    public void setHasObscore(boolean hasObscore) {
        this.hasObscore = hasObscore;
    }

    @XmlElement(name = "obscore_version")
    public String getObscoreVersion() {
        return obscoreVersion;
    }

    public void setObscoreVersion(String obscoreVersion) {
        this.obscoreVersion = obscoreVersion;
    }
}
