(function () {

    function checkSeparateCredentials() {
        var separateCredentials = $('#main\\:separate-credentials').is(':checked');
        $('#credentials-modal .modal-dialog').toggleClass('modal-lg', separateCredentials);
    }

    window.credentials = {
        editClicked: function (event) {
            if (event.status === 'success') {
                $('#credentials-modal').modal('show');
            }
        },
        credentialsSaved: function (event) {
            if (event.status === 'success') {
                if ($('#credentials-modal .text-danger').length === 0) {
                    $('#credentials-modal').modal('hide');
                }
            }
        },
        separateCredentialsChanged: function (event) {
            if (event.status === 'success') {
                checkSeparateCredentials();
            }
        },
        openConfirmDeleteModal: function (event) {
            if (event.status === 'success') {
                $('#modal-confirm-credentials-deletion').modal('show');
            }
        },
        closeConfirmDeleteModal: function (event) {
            if (event.status === 'success') {
                $('#modal-confirm-credentials-deletion').modal('hide');
            }
        }
    };

    $(document).ready(function () {
        $('body').on('show.bs.modal', '#credentials-modal', function ( ) {
            checkSeparateCredentials();
        });

        $('body').on('keyup', '#credentials-modal input', function (event) {
            if (event.keyCode === 13) {
                $('#main\\:save-credentials').click();
                event.preventDefault();
            }
        });
    });
})();
