/*
 * _____________________________________________________________________________
 * 
 * INAF - OATS National Institute for Astrophysics - Astronomical Observatory of
 * Trieste INAF - IA2 Italian Center for Astronomical Archives
 * _____________________________________________________________________________
 * 
 * Copyright (C) 2017 Istituto Nazionale di Astrofisica
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package it.inaf.ia2.tsm;

import java.io.Serializable;

/**
 * Contains all the settings specified for a TAP_SCHEMA.
 *
 * @author Sonia Zorba {@literal <zorba at oats.inaf.it>}
 */
public class TapSchemaSettings implements Serializable {

    private static final long serialVersionUID = -4152480696306984772L;

    private String tapSchemaVersion;
    private String tapSchemaName;
    private boolean hasObscore;
    private String obscoreVersion;
    private String ivoaSchemaName;

    public TapSchemaSettings() {
        tapSchemaName = TapSchema.STANDARD_TAP_SCHEMA_NAME;
        ivoaSchemaName = TapSchema.STANDARD_IVOA_SCHEMA_NAME;
    }

    /**
     * TASMAN supports multiple TAP_SCHEMA versions; schemata structure change
     * from one version to another and the definition of this structure is
     * stored into XML files inside the {@code schema_definition} resource
     * folder.
     */
    public String getTapSchemaVersion() {
        return tapSchemaVersion;
    }

    /**
     * @see #getTapSchemaVersion()
     */
    public void setTapSchemaVersion(String tapSchemaVersion) {
        this.tapSchemaVersion = tapSchemaVersion;
    }

    /**
     * Returns the name of the TAP_SCHEMA schema, as saved into the database.
     * The name can be different from the exposed name if schema renaming is
     * enabled.
     */
    public String getTapSchemaName() {
        return tapSchemaName;
    }

    public void setTapSchemaName(String tapSchemaName) {
        this.tapSchemaName = tapSchemaName;
    }

    /**
     * Tells if the {@code ObsCore} table should be managed by TASMAN.
     */
    public boolean isHasObscore() {
        return hasObscore;
    }

    public void setHasObscore(boolean hasObscore) {
        this.hasObscore = hasObscore;
    }

    public String getObscoreVersion() {
        return obscoreVersion;
    }

    public void setObscoreVersion(String obscoreVersion) {
        this.obscoreVersion = obscoreVersion;
    }

    /**
     * Returns the name of the ivoa schema, as saved into the database. The name
     * can be different from the exposed name if schema renaming is enabled.
     */
    public String getIvoaSchemaName() {
        return ivoaSchemaName;
    }

    public void setIvoaSchemaName(String ivoaSchemaName) {
        this.ivoaSchemaName = ivoaSchemaName;
    }
}
