package it.inaf.ia2.tsm;

import ch.vorburger.mariadb4j.DB;
import ch.vorburger.mariadb4j.DBConfigurationBuilder;
import com.opentable.db.postgres.embedded.UncompressBundleDirectoryResolver;
import com.opentable.db.postgres.embedded.EmbeddedPostgres;
import com.opentable.db.postgres.embedded.PgBinaryResolver;
import it.inaf.ia2.tsm.datalayer.Credentials;
import it.inaf.ia2.tsm.datalayer.DatabaseType;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.core.io.ClassPathResource;

public class EmbeddedDatabases {

    public static Credentials mariadbCredentials() throws Exception {

        DBConfigurationBuilder configBuilder = DBConfigurationBuilder.newBuilder();
        DB db = DB.newEmbeddedDB(configBuilder.build());
        db.start();

        Credentials mysqlCredentials = new Credentials(DatabaseType.MYSQL);
        mysqlCredentials.setHostname("127.0.0.1");
        mysqlCredentials.setPort(configBuilder.getPort());
        mysqlCredentials.setUsername("root");
        mysqlCredentials.setPassword("");

        return mysqlCredentials;
    }

    public static Credentials postgresCredentials() throws Exception {

        EmbeddedPostgres embeddedPg = EmbeddedPostgres.builder()
                .setPgDirectoryResolver(new UncompressBundleDirectoryResolver(new CustomPostgresBinaryResolver()))
                .start();

        Credentials postgresCredentials = new Credentials(DatabaseType.POSTGRES);
        postgresCredentials.setHostname("127.0.0.1");
        postgresCredentials.setPort(embeddedPg.getPort());
        postgresCredentials.setUsername("postgres");
        postgresCredentials.setPassword("");
        postgresCredentials.setDatabase("postgres");

        return postgresCredentials;
    }

    private static class CustomPostgresBinaryResolver implements PgBinaryResolver {

        /**
         * Loads specific embedded Postgres version.
         */
        @Override
        public InputStream getPgBinary(String system, String architecture) throws IOException {
            ClassPathResource resource = new ClassPathResource(String.format("postgres-%s-%s.txz", system.toLowerCase(), architecture));
            return resource.getInputStream();
        }
    }

}
