package it.inaf.ia2.tsm.webapp;

import it.inaf.ia2.tsm.webapp.xmlconfig.UserConfiguration;
import java.io.IOException;
import javax.enterprise.context.RequestScoped;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.inject.Named;

/**
 *
 * @author Sonia Zorba {@literal <zorba at oats.inaf.it>}
 */
@Named
@RequestScoped
public class FirstSetup {
    
    @Inject
    ConfigurationManager config;
    
    private String adminUsername;
    private String adminPassword;
    private String adminPasswordConfirm;
    
    public String createAdmin() throws IOException {
        if (adminPassword.equals(adminPasswordConfirm)) {
            UserConfiguration userConfig = new UserConfiguration();
            userConfig.setUsername(adminUsername);
            userConfig.setPassword(adminPassword);
            userConfig.setRole("admin");
            
            config.addUser(userConfig);
            
            return "index.xhtml?faces-redirect=true";
        } else {
            FacesContext.getCurrentInstance().addMessage("admin-password-confirm", new FacesMessage("Passwords don't match"));
        }
        return null;
    }
    
    public String getAdminUsername() {
        return adminUsername;
    }
    
    public void setAdminUsername(String adminUsername) {
        this.adminUsername = adminUsername;
    }
    
    public String getAdminPassword() {
        return adminPassword;
    }
    
    public void setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
    }
    
    public String getAdminPasswordConfirm() {
        return adminPasswordConfirm;
    }
    
    public void setAdminPasswordConfirm(String adminPasswordConfirm) {
        this.adminPasswordConfirm = adminPasswordConfirm;
    }
}
