/*
 * _____________________________________________________________________________
 * 
 * INAF - OATS National Institute for Astrophysics - Astronomical Observatory of
 * Trieste INAF - IA2 Italian Center for Astronomical Archives
 * _____________________________________________________________________________
 * 
 * Copyright (C) 2017 Istituto Nazionale di Astrofisica
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package it.inaf.ia2.tsm;

import java.io.Serializable;

/**
 *
 * @author Sonia Zorba {@literal <zorba at oats.inaf.it>}
 */
public class WrongDataType implements Serializable {

    private static final long serialVersionUID = 1541867434766884291L;

    private ColumnHolder columnHolder;
    private String wrongDataType;
    private String correctDataType;
    private String adqlCorrectDataType;
    private Integer size;

    public WrongDataType() {
    }

    public WrongDataType(ColumnHolder columnHolder, String wrongDataType, String correctDataType, String adqlCorrectDataType, Integer size) {
        this.columnHolder = columnHolder;
        this.wrongDataType = wrongDataType;
        this.correctDataType = correctDataType;
        this.adqlCorrectDataType = adqlCorrectDataType;
        this.size = size;
    }

    public ColumnHolder getColumnHolder() {
        return columnHolder;
    }

    public void setColumnHolder(ColumnHolder columnHolder) {
        this.columnHolder = columnHolder;
    }

    public String getWrongDataType() {
        return wrongDataType;
    }

    public void setWrongDataType(String wrongDataType) {
        this.wrongDataType = wrongDataType;
    }

    public String getCorrectDataType() {
        return correctDataType;
    }

    public void setCorrectDataType(String correctDataType) {
        this.correctDataType = correctDataType;
    }

    public String getAdqlCorrectDataType() {
        return adqlCorrectDataType;
    }

    public void setAdqlCorrectDataType(String adqlCorrectDataType) {
        this.adqlCorrectDataType = adqlCorrectDataType;
    }

    public Integer getSize() {
        return size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }
}
