/*
 * _____________________________________________________________________________
 * 
 * INAF - OATS National Institute for Astrophysics - Astronomical Observatory of
 * Trieste INAF - IA2 Italian Center for Astronomical Archives
 * _____________________________________________________________________________
 * 
 * Copyright (C) 2018 Istituto Nazionale di Astrofisica
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package it.inaf.ia2.tsm.webapp.env;

import it.inaf.ia2.tsm.Column;
import it.inaf.ia2.tsm.Status;
import it.inaf.ia2.tsm.Table;
import it.inaf.ia2.tsm.webapp.TapSchemaEditingBean;
import java.io.Serializable;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.deltaspike.core.api.scope.WindowScoped;

/**
 *
 * @author Sonia Zorba {@literal <zorba at oats.inaf.it>}
 */
@Path("sort-columns")
@WindowScoped
public class ColumnsSorterResource implements Serializable {

    private static final long serialVersionUID = -4884593153477048736L;

    @Inject
    private TapSchemaEditingBean tapSchemaEditor;

    @POST
    @Consumes(MediaType.APPLICATION_JSON)
    public Response setColumnsOrder(List<String> columns) {

        Table table = tapSchemaEditor.getSelectedTable();

        for (Column column : table.getChildren(Status.ADDED_PERSISTED, Status.ADDED_NOT_PERSISTED)) {
            column.setValue(Column.COLUMN_INDEX, null);
        }

        int index = 0;
        for (String columnName : columns) {
            Column column = table.getChild(columnName);
            column.setValue(Column.COLUMN_INDEX, ++index);
        }

        return Response.ok(index).build();
    }
}
