/*
 * _____________________________________________________________________________
 * 
 * INAF - OATS National Institute for Astrophysics - Astronomical Observatory of
 * Trieste INAF - IA2 Italian Center for Astronomical Archives
 * _____________________________________________________________________________
 * 
 * Copyright (C) 2017 Istituto Nazionale di Astrofisica
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package it.inaf.ia2.tsm.webapp;

import java.io.Serializable;
import uk.me.nxg.unity.Syntax;
import uk.me.nxg.unity.UnitExpr;
import uk.me.nxg.unity.UnitParser;

/**
 * Serializable wrapper for VOUnit UnitExpr
 *
 * @author Sonia Zorba {@literal <zorba at oats.inaf.it>}
 */
public class VOUnitValidator implements Serializable {

    private static final long serialVersionUID = -1019359441934896102L;

    private static final Syntax syntax = Syntax.lookup("vounits");

    private final boolean unset;
    private boolean parsable;
    private boolean allUnitsRecognised;
    private boolean allUnitsRecommended;
    private boolean allUsageConstraintsSatisfied;
    private String exceptionMessage;

    public VOUnitValidator(String value) {

        unset = value == null || value.isEmpty();

        if (!unset) {
            try {
                UnitParser parser = new UnitParser(syntax, value);
                UnitExpr expr = parser.getParsed();
                allUnitsRecognised = expr.allUnitsRecognised(syntax);
                allUnitsRecommended = expr.allUnitsRecommended(syntax);
                allUsageConstraintsSatisfied = expr.allUsageConstraintsSatisfied(syntax);
                parsable = true;
            } catch (Throwable t) {
                exceptionMessage = t.getMessage();
            }
        }
    }

    public boolean isUnset() {
        return unset;
    }

    public boolean isParsable() {
        return parsable;
    }

    public boolean isAllUnitsRecognised() {
        return allUnitsRecognised;
    }

    public boolean isAllUnitsRecommended() {
        return allUnitsRecommended;
    }

    public boolean isAllUsageConstraintsSatisfied() {
        return allUsageConstraintsSatisfied;
    }

    public String getExceptionMessage() {
        return exceptionMessage;
    }
}
