/* 
 * _____________________________________________________________________________
 * 
 * INAF - OATS National Institute for Astrophysics - Astronomical Observatory of
 * Trieste INAF - IA2 Italian Center for Astronomical Archives
 * _____________________________________________________________________________
 * 
 * Copyright (C) 2016 Istituto Nazionale di Astrofisica
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package it.inaf.ia2.tsm.webapp;

import it.inaf.ia2.tsm.webapp.env.CustomPartialResponseWriter;
import it.inaf.ia2.tsm.webapp.xmlconfig.UserConfiguration;
import java.io.Serializable;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.deltaspike.core.api.scope.WindowScoped;

/**
 *
 * @author Sonia Zorba {@literal <zorba at oats.inaf.it>}
 */
@Named
@WindowScoped
public class UsersEditing implements Serializable {

    private static final long serialVersionUID = -8758568990541836689L;

    @Inject
    private ConfigurationManager config;

    private UserConfiguration userInEditing;
    private UserConfiguration userToRemove;

    private boolean newUser;
    private String password;
    private String passwordConfirm;
    private String role;

    public String open() {
        return "usersEditing.xhtml?faces-redirect=true";
    }

    public List<UserConfiguration> getUsers() {
        return config.getUsersConfiguration();
    }

    public void editNewUser() {
        newUser = true;
        userInEditing = new UserConfiguration();
        role = "user";
    }

    public void editExistingUser(UserConfiguration user) {
        newUser = false;
        userInEditing = user;
        role = user.getRole();
    }

    public UserConfiguration getUserInEditing() {
        return userInEditing;
    }

    public boolean isNewUser() {
        return newUser;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPasswordConfirm() {
        return passwordConfirm;
    }

    public void setPasswordConfirm(String passwordConfirm) {
        this.passwordConfirm = passwordConfirm;
    }

    public String getRole() {
        return role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public UserConfiguration getUserToRemove() {
        return userToRemove;
    }

    public void setUserToRemove(UserConfiguration userToRemove) {
        this.userToRemove = userToRemove;
    }

    public void saveEdit() {
        boolean canSave = true;

        if (userInEditing.getUsername() == null || userInEditing.getUsername().isEmpty()) {
            FacesContext.getCurrentInstance().addMessage("main:username", new FacesMessage("Username is required"));
            canSave = false;
        }

        if (canSave && newUser) {
            for (UserConfiguration user : config.getUsersConfiguration()) {
                if (user.getUsername().equals(userInEditing.getUsername())) {
                    FacesContext.getCurrentInstance().addMessage("main:username", new FacesMessage("This username already exists."));
                    canSave = false;
                    break;
                }
            }
        }

        if (password == null || password.isEmpty()) {
            FacesContext.getCurrentInstance().addMessage("main:password", new FacesMessage("Password is required"));
            canSave = false;
        }

        if (password != null && !password.equals(passwordConfirm)) {
            FacesContext.getCurrentInstance().addMessage("main:confirm-password", new FacesMessage("Passwords don't match"));
            canSave = false;
        }

        CustomPartialResponseWriter.getCurrentInstance().addCustomJSUpdate(String.valueOf(canSave));

        if (canSave) {
            if (newUser) {
                userInEditing.setRole(role);
                userInEditing.setPassword(password);
                config.addUser(userInEditing);
            } else {
                config.editUser(userInEditing.getUsername(), role, password);
            }
        }
    }

    public void confirmUserDeletion() {
        if (userToRemove != null) {
            config.deleteUser(userToRemove.getUsername());
        }
    }
}
