/*
 * _____________________________________________________________________________
 * 
 * INAF - OATS National Institute for Astrophysics - Astronomical Observatory of
 * Trieste INAF - IA2 Italian Center for Astronomical Archives
 * _____________________________________________________________________________
 * 
 * Copyright (C) 2017 Istituto Nazionale di Astrofisica
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package it.inaf.ia2.tsm;

import java.io.Serializable;

/**
 *
 * @author Sonia Zorba {@literal <zorba at oats.inaf.it>}
 */
public class TapSchemaSettings implements Serializable {

    private static final long serialVersionUID = -4152480696306984772L;

    private String tapSchemaVersion;
    private String tapSchemaName;
    private boolean hasObscore;
    private String obscoreVersion;
    private String ivoaSchemaName;

    public TapSchemaSettings() {
        tapSchemaName = TapSchema.STANDARD_TAP_SCHEMA_NAME;
        ivoaSchemaName = TapSchema.STANDARD_IVOA_SCHEMA_NAME;
    }

    public String getTapSchemaVersion() {
        return tapSchemaVersion;
    }

    public void setTapSchemaVersion(String tapSchemaVersion) {
        this.tapSchemaVersion = tapSchemaVersion;
    }

    public String getTapSchemaName() {
        return tapSchemaName;
    }

    public void setTapSchemaName(String tapSchemaName) {
        this.tapSchemaName = tapSchemaName;
    }

    public boolean isHasObscore() {
        return hasObscore;
    }

    public void setHasObscore(boolean hasObscore) {
        this.hasObscore = hasObscore;
    }

    public String getObscoreVersion() {
        return obscoreVersion;
    }

    public void setObscoreVersion(String obscoreVersion) {
        this.obscoreVersion = obscoreVersion;
    }

    public String getIvoaSchemaName() {
        return ivoaSchemaName;
    }

    public void setIvoaSchemaName(String ivoaSchemaName) {
        this.ivoaSchemaName = ivoaSchemaName;
    }
}
