/*
 * _____________________________________________________________________________
 * 
 * INAF - OATS National Institute for Astrophysics - Astronomical Observatory of
 * Trieste INAF - IA2 Italian Center for Astronomical Archives
 * _____________________________________________________________________________
 * 
 * Copyright (C) 2017 Istituto Nazionale di Astrofisica
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package it.inaf.ia2.tsm;

import java.io.Serializable;

/**
 * Model used during consistency checking phase to represents a 
 * 
 * 
 * @author Sonia Zorba {@literal <zorba at oats.inaf.it>}
 */
public class KeyHolder implements Serializable {

    private static final long serialVersionUID = 3711149068153684261L;

    private final String keyId;
    private final String fromTable;
    private final String[] fromColumns;
    private final String targetTable;
    private final String[] targetColumns;

    public KeyHolder(String keyId, String fromTable, String[] fromColumns, String targetTable, String[] targetColumns) {
        this.keyId = keyId;
        this.fromTable = fromTable;
        this.fromColumns = fromColumns;
        this.targetTable = targetTable;
        this.targetColumns = targetColumns;
    }

    public String getKeyId() {
        return keyId;
    }

    public String getFromTable() {
        return fromTable;
    }

    public String[] getFromColumns() {
        return fromColumns;
    }

    public String getTargetTable() {
        return targetTable;
    }

    public String[] getTargetColumns() {
        return targetColumns;
    }

    private String getColumnsString(String[] columns) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String column : columns) {
            if (!first) {
                sb.append(",");
            }
            sb.append(column);
            first = false;
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return String.format("[%s] %s(%s) -> %s(%s)", keyId,
                fromTable, getColumnsString(fromColumns),
                targetTable, getColumnsString(targetColumns));
    }
}
