#!/bin/bash

echo "############################################"
echo "#  _____  _    ____  __  __    _    _   _  #"
echo "# |_   _|/ \  / ___||  \/  |  / \  | \ | | #"
echo "#   | | / _ \ \___ \| |\/| | / _ \ |  \| | #"
echo "#   | |/ ___ \ ___) | |  | |/ ___ \| |\  | #"
echo "#   |_/_/   \_\____/|_|  |_/_/   \_\_| \_| #"
echo "#                                          #"
echo "#              Powered by IA2              #"
echo "#                                          #"
echo "############################################"
echo ""

echo "Welcome on the TASMAN installer"

# Run as root check
if [[ "$(id -u)" != "0" ]]; then
    echo "** This script must be run as root **" 1>&2
    exit 1
fi

# Default port
echo -e "Specify default port for TASMAN (you can change it runtime) [8080]: \c"
read default_port
if [[ -z "$default_port" ]]; then
    default_port=8080
fi
if [[ ! "$default_port" =~ ^-?[0-9]+$ ]]; then
    echo "Port must be a number"
    exit 1
fi
if [[ "$default_port" -lt "1024" ]]; then
    echo "Please choose a port number bigger than 1023 (TASMAN will be launched by a non-root user)"
    exit 1
fi

# Tasman installation dir
echo -e "Specify TASMAN installation directory [/opt/tasman]: \c"
read install_dir
if [[ -z "$install_dir" ]]; then
    install_dir="/opt/tasman"
fi

# UCD service URL
echo -e "Specify UCD service URL [http://ia2-vo.oats.inaf.it/ucd/]: \c"
read ucd_service_url
if [[ -z "$ucd_service_url" ]]; then
    ucd_service_url="http://ia2-vo.oats.inaf.it/ucd/"
fi

# TASMAN configuration directory
echo -e "Specify TASMAN configuration directory [/etc/tasman]: \c"
read tasman_config_dir
if [[ -z "$tasman_config_dir" ]]; then
    tasman_config_dir="/etc/tasman"
fi
mkdir -p "$tasman_config_dir"
if [ ! $? -eq 0 ]; then
    echo "Unable to create configuration directory $tasman_config_dir"
    exit 1
fi

# Creating tasman user if it is necessary
#if [[ ! $(getent passwd tasman) ]]; then
#    useradd -r tasman
#fi

# Creating installation directory
mkdir -p "$install_dir"
if [ ! $? -eq 0 ]; then
    echo "Unable to create installation directory $install_dir"
    exit 1
fi

# Add final slash to installation dir if it is necessary
if [[ "$install_dir" != *\/ ]]; then
   install_dir="$install_dir/"
fi

# Copying files
cp data/tasman-embedded.jar "$install_dir"
cp data/tasman-webapp.war "$install_dir"

cd $install_dir

# Configuring tasman-embedded
echo "warFilePath=$install_dir""tasman-webapp.war" > app.properties
echo "defaultPort=$default_port" >> app.properties

jar uf tasman-embedded.jar app.properties
rm app.properties

# Configuring tasman-webapp
echo "ucd_service_url=$ucd_service_url" > webapp.properties
echo "config_directory=$tasman_config_dir" >> webapp.properties
mkdir -p WEB-INF/classes
mv webapp.properties WEB-INF/classes
jar uf tasman-webapp.war WEB-INF/classes/webapp.properties
rm -Rf WEB-INF

cd - 1> /dev/null

# Creating executable
tasman_bin="$install_dir""tasman"
echo "#!/bin/bash" > $tasman_bin
echo "java -jar $install_dir""tasman-embedded.jar" >> $tasman_bin
chmod +x $tasman_bin

# Creating executable symbolic link
ln -s $tasman_bin /usr/bin/tasman

# Setting permissions
chmod -R 777 $tasman_config_dir

echo "######################################"
echo "# TASMAN installation completed! :-) #"
echo "######################################"
echo "Notice that $tasman_config_dir has 777 permissions. If you are planning to use TASMAN only with a specific user you may want to restrict permissions on that folder."
