package it.inaf.ia2.tsm.webapp.checker;

import it.inaf.ia2.tsm.webapp.User;
import javax.enterprise.context.RequestScoped;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.inject.Named;

/**
 *
 * @author Sonia Zorba {@literal <zorba at oats.inaf.it>}
 */
@Named
@RequestScoped
public class LoggedInChecker {

    @Inject
    private User user;

    public void checkFromIndex() {
        if (user.isLoggedIn()) {
            FacesContext fc = FacesContext.getCurrentInstance();
            fc.getApplication().getNavigationHandler().handleNavigation(fc, null, "/credentialsEditing.xhtml?faces-redirect=true");
        }
    }

    public void checkFromNonIndex() {
        if (!user.isLoggedIn()) {
            FacesContext fc = FacesContext.getCurrentInstance();
            fc.getApplication().getNavigationHandler().handleNavigation(fc, null, "/index.xhtml?faces-redirect=true");
        }
    }
}
