/* 
 * _____________________________________________________________________________
 * 
 * INAF - OATS National Institute for Astrophysics - Astronomical Observatory of
 * Trieste INAF - IA2 Italian Center for Astronomical Archives
 * _____________________________________________________________________________
 * 
 * Copyright (C) 2016 Istituto Nazionale di Astrofisica
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package it.inaf.ia2.tsm;

/**
 * Define the persistence status of a {@link ChildEntity}.
 *
 * @author Sonia Zorba {@literal <zorba at oats.inaf.it>}
 */
public enum Status {

    /**
     * Information about the entity has been loaded from the database (e.g. for
     * performance reason) but the entity hasn't been added to the TAP_SCHEMA.
     * Currently only {@code Column}s uses this state.
     */
    LOADED,
    /**
     * The entity was added to the TAP_SCHEMA and this fact is stored into the
     * database.
     */
    ADDED_PERSISTED,
    /**
     * The entity is marked as added, but it hasn't been saved to the database
     * yet.
     */
    ADDED_NOT_PERSISTED,
    /**
     * The entity is marked as removed but it is still written into the
     * database, so it will be removed from it only when the
     * {@link TapSchema#save()} method is called.
     */
    TO_REMOVE,
    /**
     * The entity is marked as removed but it has never been written into the
     * database.
     */
    REMOVED_NOT_PERSISTED
}
