;   Modifyed by Ferny sept 2012 calcola psf telescopio lbt con secondario no spider
;   Modified by Marco Oct 2013: added input structures and telescope jitter
;------------------------------------------------------------------
pro pisces_on_axe_phased, wavefront, wavelength, gridsize, sampling, PASSVALUE=passval

diam = 8.4d				;-- entrance aperture diameter in meters
focal_ratio = 15.0d
focal_length = diam*focal_ratio

prop_begin, wavefront, diam, wavelength, gridsize, passval.beam_ratio
prop_add_phase, wavefront,passval.fase      ;AO_residual is due in meters!!



IF PASSVAL.OSCILLATION EQ 1 THEN BEGIN
rn=randomu(seed, 1)
ax= PASSVAL.SWING_A*rn
ay= PASSVAL.SWING_A*(1.-rn)
PROP_ZERNIKES, WAVEFRONT, 2, ax
PROP_ZERNIKES, WAVEFRONT, 3, ay
ENDIF


prop_circular_aperture, wavefront, diam/2.  
prop_define_entrance, wavefront
prop_circular_obscuration, wavefront, 0.5
prop_propagate, wavefront, 10,'M1'
prop_lens, wavefront, focal_length
prop_propagate, wavefront, focal_length,'focal plane'


;prop_circular_obscuration, wavefront, occrad_m

prop_propagate, wavefront, 0.05,'collimator'
prop_lens, wavefront, 0.05
prop_propagate, wavefront, 0.05,'lyot'


;aggiungi NCPA Zernike modes

prop_zernikes, wavefront, passval.zer_num, passval.zer_val*1e-9


;Applicazione maschera olografica
if passval.HWRS eq 1 then begin
holo=readfits('/media/shark/DATA/interpolated_wfs_hologram.fits')
holo=rebin(holo, 256, 256)
holo0=fltarr(512,512)
holo0(128:128+256-1, 128:128+256-1)=holo
holo=holo0
prop_divide, wavefront, 2
Ep=wavefront
Em=wavefront
prop_add_Phase, Ep, wavelength*holo/(2.*!pi)
prop_add_Phase, Em, -wavelength*holo/(2.*!pi)
wavefront.wavefront=Ep.wavefront+Em.wavefront
endif




;prop_circular_aperture, wavefront, passval.lyotstop,/norm     ;Lyot *******************
beam=PROP_GET_BEAMRADIUS(wavefront)
prop_circular_aperture, wavefront, beam*(passval.lyotstop), passval.lyot_xoff, passval.lyot_yoff     ;Lyot *******************


prop_circular_obscuration, wavefront, passval.suppressor,/norm  ;secondary spot suppressor



prop_propagate, wavefront, 0.05,'camera'
prop_lens, wavefront, 0.05
prop_propagate, wavefront, 0.05,'detector'
pix=prop_get_sampling_arcsec(wavefront)*1000.
passval.sampl=pix
prop_end, wavefront, sampling
return
end
